@extends('layouts.admin')

@section('content')

<!-- Page Header -->
<div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-10">
    <div>
        <h1 class="text-3xl md:text-4xl font-extrabold mb-2">
            أكواد التفعيل
        </h1>
        <p class="text-slate-500">
            إنشاء وإدارة أكواد التفعيل المرتبطة بالمستخدمين
        </p>
    </div>
</div>

<!-- Stats Cards -->
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-12">
    <div class="bg-white rounded-2xl p-6 shadow hover:shadow-lg transition">
        <p class="text-sm text-slate-400 mb-1">إجمالي الأكواد</p>
        <h3 class="text-3xl font-bold">{{ $codes->count() }}</h3>
    </div>

    <div class="bg-white rounded-2xl p-6 shadow hover:shadow-lg transition">
        <p class="text-sm text-slate-400 mb-1">أكواد فعالة</p>
        <h3 class="text-3xl font-bold text-emerald-600">
            {{ $codes->where('status','active')->count() }}
        </h3>
    </div>

    <div class="bg-white rounded-2xl p-6 shadow hover:shadow-lg transition">
        <p class="text-sm text-slate-400 mb-1">مستخدمة</p>
        <h3 class="text-3xl font-bold text-indigo-600">
            {{ $codes->where('status','used')->count() }}
        </h3>
    </div>

    <div class="bg-white rounded-2xl p-6 shadow hover:shadow-lg transition">
        <p class="text-sm text-slate-400 mb-1">موقوفة / منتهية</p>
        <h3 class="text-3xl font-bold text-red-500">
            {{ $codes->whereIn('status',['disabled'])->count() }}
        </h3>
    </div>
</div>

<!-- Create Code Card -->
<div class="bg-white rounded-3xl shadow-lg p-8 mb-14 animate-fade-in">
    <h2 class="text-2xl font-bold mb-6 flex items-center gap-2">
        <span class="text-indigo-600">＋</span> إنشاء كود جديد
    </h2>

    <form method="POST" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-6">
        @csrf

        <input
            name="owner_name"
            required
            placeholder="اسم صاحب الكود"
            class="rounded-xl border px-4 py-3 focus:ring-2 focus:ring-indigo-500">

        <input
            type="number"
            name="duration_value"
            min="1"
            required
            placeholder="المدة"
            class="rounded-xl border px-4 py-3 focus:ring-2 focus:ring-indigo-500">

        <select
            name="duration_type"
            class="rounded-xl border px-4 py-3 focus:ring-2 focus:ring-indigo-500">
            <option value="hour">ساعات</option>
            <option value="day">أيام</option>
        </select>

        <div class="lg:col-span-2">
            <button
                class="w-full bg-indigo-600 hover:bg-indigo-700 text-white py-4 rounded-xl text-lg font-semibold transition-all duration-300 hover:scale-[1.02]">
                إنشاء الكود
            </button>
        </div>
    </form>
</div>

<!-- Codes Table -->
<div class="bg-white rounded-3xl shadow-lg overflow-x-auto">
    <table class="w-full min-w-[900px] text-sm text-center">
        <thead class="bg-slate-100 text-slate-600">
            <tr>
                <th class="p-4">الكود</th>
                <th>الاسم</th>
                <th>المتبقي</th>
                <th>الانتهاء</th>
                <th>الحالة</th>
                <th>إجراء</th>
            </tr>
        </thead>

        <tbody>
        @forelse($codes as $code)
            <tr class="border-t hover:bg-slate-50 transition duration-200">
                <td class="p-4 font-mono text-indigo-600">
                    {{ $code->code }}
                </td>

                <td class="font-medium">
                    {{ $code->owner_name }}
                </td>

                <td>
                    @if($code->status === 'active')
                        <span class="text-emerald-600 font-semibold">
                            {{ now()->diffInHours($code->expires_at) }} ساعة
                        </span>
                    @else
                        —
                    @endif
                </td>

                <td class="text-slate-500">
                    {{ $code->expires_at }}
                </td>

                <td>
                    @if($code->status === 'active')
                        <span class="px-3 py-1 rounded-full text-xs font-semibold bg-emerald-100 text-emerald-700">
                            نشط
                        </span>
                    @elseif($code->status === 'used')
                        <span class="px-3 py-1 rounded-full text-xs font-semibold bg-indigo-100 text-indigo-700">
                            مستخدم
                        </span>
                    @else
                        <span class="px-3 py-1 rounded-full text-xs font-semibold bg-red-100 text-red-700">
                            موقوف
                        </span>
                    @endif
                </td>

                <td>
                    @if($code->status === 'active')
                        <form method="POST" action="/dashboard/codes/{{ $code->id }}/disable">
                            @csrf
                            <button
                                class="text-red-600 hover:text-red-800 font-semibold transition">
                                إيقاف
                            </button>
                        </form>
                    @else
                        —
                    @endif
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="6" class="p-10 text-slate-400">
                    لا توجد أكواد حتى الآن
                </td>
            </tr>
        @endforelse
        </tbody>
    </table>
</div>

@endsection

