<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>حضوري | لوحة التحكم</title>

    @vite(['resources/css/app.css','resources/js/app.js'])
</head>

<body class="bg-slate-100 text-slate-800">

<div class="min-h-screen flex">

    <!-- Sidebar -->
    <aside class="w-64 bg-gradient-to-b from-indigo-700 to-purple-700 text-white hidden md:flex flex-col">

        <!-- Logo -->
        <div class="h-16 flex items-center px-6 text-2xl font-extrabold tracking-wide border-b border-white/10">
            حضوري
        </div>

        <!-- Menu -->
        <nav class="flex-1 px-4 py-6 space-y-2">
            <a href="/dashboard/codes"
               class="flex items-center gap-3 px-4 py-3 rounded-xl bg-white/10 hover:bg-white/20 transition">
                <span class="text-lg">🔑</span>
                <span class="font-medium">أكواد التفعيل</span>
            </a>
        </nav>

        <!-- User -->
        <div class="border-t border-white/10 p-4">
            <div class="text-sm opacity-80 mb-2">
                {{ auth()->user()->name }}
            </div>

            <form method="POST" action="/logout">
                @csrf
                <button
                    class="w-full bg-white/10 hover:bg-white/20 py-2 rounded-lg text-sm transition">
                    تسجيل الخروج
                </button>
            </form>
        </div>
    </aside>

    <!-- Content -->
    <div class="flex-1 flex flex-col">

        <!-- Topbar (Mobile) -->
        <header class="md:hidden bg-white shadow h-16 flex items-center justify-between px-4">
            <div class="font-bold text-lg text-indigo-600">حضوري</div>

            <form method="POST" action="/logout">
                @csrf
                <button class="text-red-500 text-sm">خروج</button>
            </form>
        </header>

        <!-- Page Content -->
        <main class="flex-1 p-6 md:p-10">
            @yield('content')
        </main>

    </div>

</div>

</body>
</html>

